#version 430 core 

layout ( triangles ) in;
layout ( triangle_strip, max_vertices = 3) out;
 
 //outputs

layout(location = 0) out vec3 fragViewNormal;

layout(binding = 0, rgba32f) uniform readonly restrict image2D inputTex;

mat4 lightMatrix;

vec3 calculateNormal(int location){

	int primary;
	int secondary;
	int tertiary;

	if(location == 0){
		primary = 0;
		secondary = 1;
		tertiary = 2;
	}else if(location == 1){
		primary = 1;
		secondary = 2;
		tertiary = 0;
	}else if(location == 2){
		primary = 2;
		secondary = 0;
		tertiary = 1;
	}



	vec3 tangent = gl_in[secondary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 bitangent = gl_in[tertiary].gl_Position.xyz - gl_in[primary].gl_Position.xyz;
	vec3 normal = cross(tangent, bitangent);	

	vec3 normalizedNormal = normalize(normal);

	mat3 normalMatrix = transpose(inverse(mat3(lightMatrix)));

	return normalize(normalMatrix * normalizedNormal);
}

void main(void){

	vec4 viewPosition;


	lightMatrix[0] = vec4(imageLoad(inputTex, ivec2(8, 0)));
	lightMatrix[1] = vec4(imageLoad(inputTex, ivec2(9, 0)));
	lightMatrix[2] = vec4(imageLoad(inputTex, ivec2(10, 0)));
	lightMatrix[3] = vec4(imageLoad(inputTex, ivec2(11, 0)));


	viewPosition = lightMatrix * gl_in[0].gl_Position;
	gl_Position = viewPosition;
	fragViewNormal = calculateNormal(0);
	EmitVertex();

	viewPosition = lightMatrix * gl_in[1].gl_Position;
	gl_Position = viewPosition;
	fragViewNormal = calculateNormal(1);
	EmitVertex();

	viewPosition = lightMatrix * gl_in[2].gl_Position;
	gl_Position = viewPosition;
	fragViewNormal = calculateNormal(2);
	EmitVertex();

	EndPrimitive();

}